/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.api.data.pack;

import com.gitlab.srcmc.rctmod.api.RCTMod;
import com.gitlab.srcmc.rctmod.api.config.IServerConfig;
import com.gitlab.srcmc.rctmod.api.data.pack.DataPackManager;
import com.gitlab.srcmc.rctmod.api.data.pack.IDataPackObject;
import com.gitlab.srcmc.rctmod.api.data.pack.TrainerTeam;
import com.gitlab.srcmc.rctmod.api.data.pack.TrainerType;
import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.class_2960;

public class TrainerMobData
implements IDataPackObject {
    private String type = "normal";
    private List<Set<String>> requiredDefeats = new ArrayList<Set<String>>();
    private Set<String> series = new HashSet<String>();
    private Set<String> substitutes = new HashSet<String>();
    private boolean optional;
    private int maxTrainerWins = 3;
    private int maxTrainerDefeats = 1;
    private int battleCooldownTicks = 240;
    private float spawnWeightFactor = 1.0f;
    private Set<String> biomeTagBlacklist = new HashSet<String>();
    private Set<String> biomeTagWhitelist = new HashSet<String>();
    private transient int rewardLevelCap;
    private transient Set<String> followdBy = new HashSet<String>();
    private transient Map<String, String[]> dialog = new HashMap<String, String[]>();
    private transient class_2960 textureResource;
    private transient class_2960 lootTableResource;
    private transient TrainerTeam trainerTeam;
    private transient Supplier<TrainerType> lazyType = () -> {
        TrainerType type = TrainerType.valueOf(this.type.toLowerCase());
        this.lazyType = () -> type;
        return this.lazyType.get();
    };

    public TrainerMobData() {
        this.textureResource = class_2960.method_60655((String)"rctmod", (String)"textures/trainers/default.png");
        this.lootTableResource = class_2960.method_60655((String)"rctmod", (String)"trainers/default");
        this.trainerTeam = new TrainerTeam();
    }

    public TrainerMobData(TrainerMobData origin) {
        this.type = origin.type;
        this.rewardLevelCap = origin.rewardLevelCap;
        this.requiredDefeats = List.copyOf(origin.requiredDefeats);
        this.followdBy = Set.copyOf(origin.followdBy);
        this.optional = origin.optional;
        this.maxTrainerWins = origin.maxTrainerWins;
        this.maxTrainerDefeats = origin.maxTrainerDefeats;
        this.battleCooldownTicks = origin.battleCooldownTicks;
        this.biomeTagBlacklist = Set.copyOf(origin.biomeTagBlacklist);
        this.biomeTagWhitelist = Set.copyOf(origin.biomeTagWhitelist);
        this.dialog = Map.copyOf(origin.dialog);
        this.textureResource = origin.textureResource;
        this.lootTableResource = origin.lootTableResource;
        this.trainerTeam = origin.trainerTeam;
    }

    public TrainerType getType() {
        return this.lazyType.get();
    }

    public void setRewardLevelCap(int levelCap) {
        IServerConfig cfg = RCTMod.getInstance().getServerConfig();
        this.rewardLevelCap = Math.min(100, Math.max(1, Math.max(cfg.initialLevelCap() + cfg.additiveLevelCapRequirement(), levelCap)));
    }

    public int getRewardLevelCap() {
        return this.rewardLevelCap;
    }

    public int getRequiredLevelCap() {
        IServerConfig cfg = RCTMod.getInstance().getServerConfig();
        return Math.max(1, Math.min(100, this.getTrainerTeam().getTeam().stream().map(p -> p.getLevel()).max(Integer::compare).orElse(0) + cfg.additiveLevelCapRequirement()));
    }

    public boolean isOfSeries(String seriesId) {
        return this.series.isEmpty() || this.series.contains(seriesId);
    }

    public Stream<String> getSeries() {
        return this.series.stream();
    }

    public List<Set<String>> getRequiredDefeats() {
        return Collections.unmodifiableList(this.requiredDefeats);
    }

    public Set<String> getSubstitutes() {
        return Collections.unmodifiableSet(this.substitutes);
    }

    public Stream<String> getMissingRequirements(Set<String> defeatedTrainerIds) {
        return this.getMissingRequirements(defeatedTrainerIds, false);
    }

    public Stream<String> getMissingRequirements(Set<String> defeatedTrainerIds, boolean includeAlternatives) {
        return this.requiredDefeats.stream().mapMulti((set, cons) -> {
            if (includeAlternatives) {
                if (set.stream().noneMatch(defeatedTrainerIds::contains)) {
                    set.stream().forEach(cons);
                }
            } else if (!set.isEmpty()) {
                if (set.stream().noneMatch(defeatedTrainerIds::contains)) {
                    cons.accept((String)set.stream().findFirst().get());
                }
            }
        });
    }

    public boolean isOptional() {
        return this.optional;
    }

    public int getMaxTrainerWins() {
        return this.maxTrainerWins;
    }

    public int getMaxTrainerDefeats() {
        return this.maxTrainerDefeats;
    }

    public int getBattleCooldownTicks() {
        return this.battleCooldownTicks;
    }

    public float getSpawnWeightFactor() {
        return this.spawnWeightFactor;
    }

    public Set<String> getBiomeTagBlacklist() {
        return Collections.unmodifiableSet(this.biomeTagBlacklist);
    }

    public Set<String> getBiomeTagWhitelist() {
        return Collections.unmodifiableSet(this.biomeTagWhitelist);
    }

    public Set<String> getFollowedBy() {
        return Collections.unmodifiableSet(this.followdBy);
    }

    public boolean addFollowedBy(String trainerId) {
        return this.followdBy.add(trainerId);
    }

    public boolean removeFollowdBy(String trainerId) {
        return this.followdBy.remove(trainerId);
    }

    public void clearFollowedBy(String trainerId) {
        this.followdBy.clear();
    }

    public Map<String, String[]> getDialog() {
        return Collections.unmodifiableMap(this.dialog);
    }

    public class_2960 getTextureResource() {
        return this.textureResource;
    }

    public class_2960 getLootTableResource() {
        return this.lootTableResource;
    }

    public TrainerTeam getTrainerTeam() {
        return this.trainerTeam;
    }

    @Override
    public void onLoad(DataPackManager dpm, String trainerId, String context) {
        Optional<TrainerTeam> trainerTeam;
        Optional<class_2960> lootTableResource = dpm.findResource(trainerId, "loot_table");
        Optional<class_2960> textureResource = dpm.findResource(trainerId, "textures");
        if (textureResource.isPresent()) {
            this.textureResource = textureResource.get();
        }
        if (lootTableResource.isPresent()) {
            this.lootTableResource = class_2960.method_60655((String)"rctmod", (String)lootTableResource.get().method_12832().replace("loot_table/", "").replace(".json", ""));
        }
        dpm.loadResource(trainerId, "dialogs", dialog -> {
            this.dialog = dialog;
        }, new TypeToken<Map<String, String[]>>(this){});
        if (this.dialog == null) {
            this.dialog = new HashMap<String, String[]>();
        }
        if ((trainerTeam = dpm.loadTrainerTeam(trainerId)).isPresent()) {
            this.trainerTeam = trainerTeam.get();
        }
    }
}

